/*---------------------------------------------------------------------\
|                          ____ _   __ __ ___                          |
|                         |__  / \ / / . \ . \                         |
|                           / / \ V /|  _/  _/                         |
|                          / /__ | | | | | |                           |
|                         /_____||_| |_| |_|                           |
|                                                                      |
\---------------------------------------------------------------------*/
/** \file	zypp/base/Unit.cc
 *
*/
#include <zypp/base/String.h>

#include <zypp/base/Unit.h>

///////////////////////////////////////////////////////////////////
namespace zypp
{ /////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////
  namespace base
  { /////////////////////////////////////////////////////////////////

    std::string Unit::form( double val_r,
                            const std::string & symbol_r,
                            unsigned field_width_r,
                            unsigned unit_width_r,
                            unsigned prec_r )
    {
      std::string ret = str::form( "%*.*f", field_width_r, prec_r, val_r );
      if ( unit_width_r )
        {
          ret +=  str::form( " %*s", unit_width_r, symbol_r.c_str() );
        }
      return ret;
    }

    /////////////////////////////////////////////////////////////////
  } // namespace base
  ///////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////
} // namespace zypp
///////////////////////////////////////////////////////////////////
