<?php
/**
 * Controller for photos
 *
 * This file is part of Zoph.
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @package Zoph
 * @author Jeroen Roos
 */

namespace photos;

use conf\conf;
use generic\controller as genericController;
use photo\collection;
use web\request;

use user;

use photoNotAccessibleSecurityException;

/**
 * Controller for photos
 */
class controller extends genericController {

    /** @var array Actions that can be used in this controller */
    protected   $actions    = array("display", "edit", "search");

    /** @var string Where to redirect after actions */
    public $redirect="photos.php";

    /** @var int total number of photos return by the query */
    public $photocount = 0;

    /** @var params holds params object, containing params parameters
                       such as sort order, number of rows and columns */
    private $params;

    /** @var array holds array of photo_ids that are in the user's lightbox */
    private $lbPhotos = array();

    /** @var photo\collection holds collection of photos to work with */
    private $collection;

    /** @var photo\collection holds collection of photos to show */
    private $toDisplay;

    /**
     * Create a controller using a web request
     * @param request request
     */
    public function __construct(request $request) {
        parent::__construct($request);

        $this->params = new params($request);

        $this->lbPhotos = $this->params->getLightBox();

        $this->collection = collection::createFromRequest($request);
        $this->toDisplay = $this->collection->subset(
            $this->params->offset, $this->params->cells);

    }

   /**
    * Get the photo collection for the current request
    * @return photo\collection
    */  
    public function getPhotos() {
        return $this->collection;
    }

   /**
    * Get the photo collection that should be displayed
    * this is different from @see getPhotos() as this takes paging
    * into account, so it will usually only return a subset of photos
    * @return photo\collection
    */  
    public function getDisplay() {
        return $this->toDisplay;
    }

   /**
    * Get the photo_ids that are in the user's lightbox
    * @return array
    */  
    public function getLightbox() {
        return $this->lbPhotos;
    }

   /**
    * Get a params object, containing various variables to do with the interface
    * such as sort order, number of columns, rows, etc.
    * @return photos\params Params object
    */  
    public function getParams() {
        return $this->params;
    }

    /**
     * Do action 'display'
     */
    public function actionDisplay() {
        $this->view="display";
    }

    /**
     * Do action 'edit'
     * @todo not implemented yet
     * @codeCoverageIgnore
     */
    public function actionEdit() {
        $this->view="edit";
    }

    /**
     * Do action 'search'
     * @todo not implemented yet
     * @codeCoverageIgnore
     */
    public function actionSearch() {
        $this->view="search";
    }

}
