/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.office2007;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class Office2007Painter
extends BasicPainter {
    public static final String IS_MENU_PART_BUTTON = "isMenuPartButton";
    private static Office2007Painter _instance;
    private ThemePainter _defaultPainter;
    private static final Color[] STATUS_BAR_BG;
    private static final Color[] SPECIAL_STATUS_BAR_BG;
    private static final Color[] DOCKABLE_FRAME_TITLE_BAR_BG;
    private static final Color[] ACTIVE_DOCKABLE_FRAME_TITLE_BAR_BG;
    private static final Color[] COLLAPSIBLE_PANE_TITLE_BAR_BG;
    private static final Color[] EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_BG;
    private static final Color[] COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG;
    private static final Color[] EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new Office2007Painter();
        }
        return _instance;
    }

    protected Office2007Painter() {
    }

    protected ThemePainter createDefaultPainter() {
        return Office2003Painter.getInstance();
    }

    public ThemePainter getDefaultPainter() {
        if (this._defaultPainter == null) {
            this._defaultPainter = this.createDefaultPainter();
        }
        return this._defaultPainter;
    }

    @Override
    public void installDefaults() {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.installDefaults();
        }
    }

    @Override
    public void uninstallDefaults() {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.uninstallDefaults();
        }
    }

    @Override
    public Color getMenuItemBorderColor() {
        return new Color(100, 100, 100);
    }

    @Override
    public void paintContentBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Graphics2D g2d = (Graphics2D)g.create();
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        g2d.setColor(highContrast != false ? UIDefaultsLookup.getColor("Content.background") : new Color(0xBFDBFF));
        g2d.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2d.dispose();
    }

    private void paintButtonBorder(Component c, Graphics g, Rectangle rect, int state) {
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        Graphics2D gfx = (Graphics2D)g;
        if (state == 3 || state == 1) {
            gfx.setColor(new Color(9139796));
            gfx.drawLine(x + 1, y, x + w - 2, y);
            gfx.setPaint(new GradientPaint(x, y + 1, new Color(9139796), x, y + h - 3, new Color(12892584)));
            gfx.drawLine(x, y + 1, x, y + h - 3);
            gfx.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 3);
            gfx.setColor(new Color(15977082));
            gfx.drawLine(x, y + h - 3, x, y + h - 3);
            gfx.drawLine(x + w - 1, y + h - 3, x + w - 1, y + h - 3);
            if (c instanceof JideSplitButton && BasicJideButtonUI.shouldWrapText(c)) {
                gfx.setColor(new Color(13680517));
                gfx.drawLine(x, y + h - 30, x + w, y + h - 30);
            }
        } else if (state == 2) {
            if (h != 0) {
                Paint lgp = JideSwingUtilities.getLinearGradientPaint(x, y, x, y + h, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(14207638), new Color(12165236), new Color(12102030)});
                gfx.setPaint(lgp);
            }
            gfx.drawLine(x, y + 1, x, h - 2);
            gfx.setColor(new Color(14405273));
            gfx.drawLine(x + 1, y, x + w - 2, y);
            gfx.setPaint(new GradientPaint(x, y + h, new Color(12299927), x + (w >> 1), y + h, new Color(13353898), true));
            gfx.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
            if (h - 1 != 0) {
                gfx.setPaint(JideSwingUtilities.getLinearGradientPaint(x + w - 1, y, x + w - 1, y + h - 1, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(14470810), new Color(12823418), new Color(13815481)}));
            }
            gfx.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            gfx.setColor(new Color(15393448));
            gfx.drawLine(x + 1, y + 1, x + 1, y + 1);
            gfx.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            gfx.setColor(new Color(15786940));
            gfx.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
            gfx.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
        } else if (state == 0) {
            gfx.setColor(new Color(7836601));
            if (c instanceof JideButton && ((JideButton)c).getButtonStyle() == 0) {
                gfx.drawLine(x + 1, y, x + w - 2, y);
                gfx.drawLine(x, y + 1, x, y + h - 2);
                gfx.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
                gfx.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
                gfx.setColor(new Color(10269908));
                gfx.drawLine(x + 1, y + 1, x + 1, y + 1);
                gfx.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                gfx.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                gfx.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
            } else {
                gfx.drawLine(x + 1, y, x + w - 1, y);
                gfx.drawLine(x, y + 1, x, y + h - 1);
                gfx.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                gfx.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    @Override
    public void paintButtonBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state, boolean showBorder) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintButtonBackground(c, g, rect, orientation, state, showBorder);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintButtonBackground(c, g, rect, orientation, state, showBorder);
            return;
        }
        Color background = null;
        switch (state) {
            case 0: {
                background = c.getBackground();
                break;
            }
            case 2: {
                if (!(c instanceof ComponentStateSupport)) break;
                background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(state);
                break;
            }
            case 3: {
                if (!(c instanceof ComponentStateSupport)) break;
                background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(state);
                break;
            }
            case 5: {
                if (!(c instanceof ComponentStateSupport)) break;
                background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(state);
                break;
            }
            case 1: {
                if (!(c instanceof ComponentStateSupport)) break;
                background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(state);
            }
        }
        if (background != null && !(background instanceof UIResource)) {
            this.getDefaultPainter().paintButtonBackground(c, g, rect, orientation, state, showBorder);
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        if (!showBorder) {
            --x;
            --y;
            width += 2;
            height += 2;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        if (state == 1) {
            Office2007Painter.paintShadowedButtonBackground(g2d, rect, new Color[]{new Color(16624913), new Color(16161816), new Color(16229415), new Color(15771740)}, new Color[]{new Color(16623720), new Color(16551741), new Color(16560957)});
        } else if (state == 2) {
            if (c.getClientProperty(IS_MENU_PART_BUTTON) == Boolean.TRUE) {
                if (1 != height - 2) {
                    g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x + 1, y + 1, x + 1, y + height - 2, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(0xFFFEE2), new Color(16768115), new Color(16766560), new Color(16771752)}));
                }
                g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
            } else {
                g2d.setPaint(new GradientPaint(x, y, new Color(0xFFFFFF), x, y + height, new Color(16773982)));
                g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
                g2d.setPaint(new GradientPaint(x, y, new Color(16775058), x + width >> 1, y, new Color(0xFFFFFF), true));
                g2d.drawLine(x, y + height - 2, x + width, y + height - 2);
                if (2 != height - 4) {
                    g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x + 2, y + 2, x + 2, y + height - 4, new float[]{0.0f, 0.36f, 0.37f, 0.38f, 1.0f}, new Color[]{new Color(0xFFFDDF), new Color(16770964), new Color(16699744), new Color(16698712), new Color(16770964)}));
                }
                g2d.fillRect(x + 2, y + 2, width - 4, height - 4);
            }
        } else if (state == 3) {
            Office2007Painter.paintShadowedButtonBackground(g2d, rect, new Color[]{new Color(15978405), new Color(15774041), new Color(15839569), new Color(16500832)}, new Color[]{new Color(16633240), new Color(16298843), new Color(16504194)});
        } else if (state == 5) {
            int i;
            Color[] baseColors = new Color[]{new Color(15978405), new Color(15774041), new Color(15839569), new Color(16500832)};
            Color[] innerBackgroundColors = new Color[]{new Color(16633240), new Color(16298843), new Color(16504194)};
            int length = baseColors.length;
            for (i = 0; i < length; ++i) {
                baseColors[i] = ColorUtils.toGrayscale(baseColors[i]);
            }
            length = innerBackgroundColors.length;
            for (i = 0; i < length; ++i) {
                innerBackgroundColors[i] = ColorUtils.toGrayscale(innerBackgroundColors[i]);
            }
            Office2007Painter.paintShadowedButtonBackground(g2d, rect, baseColors, innerBackgroundColors);
        } else if (state == 0) {
            if (1 != height - 2) {
                g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x + 1, y + 1, x + 1, y + height - 2, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(15266300), new Color(15266300), new Color(13820404), new Color(15463421)}));
            }
            g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
        }
        if (showBorder) {
            g2d.setComposite(AlphaComposite.getInstance(10));
            this.paintButtonBorder(c, g2d, rect, state);
        }
        g2d.dispose();
    }

    static void paintShadowedButtonBackground(Graphics2D gfx, Rectangle rect, Color[] baseColors, Color[] innerBackgroundColors) {
        assert (baseColors.length == 4 && innerBackgroundColors.length == 3);
        int x = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        if (1 != height - 2) {
            gfx.setPaint(JideSwingUtilities.getLinearGradientPaint(x + 1, y + 1, x + width - 2, y + height - 2, new float[]{0.0f, 0.6f, 0.61f, 1.0f}, baseColors));
        }
        gfx.fillRect(x + 1, y + 1, width - 2, height - 2);
        Area base = new Area(new Rectangle(x + 2, y + 1, width - 4, height - 3));
        base.subtract(new Area(new Rectangle(x + 2, y + height - 3, 1, 1)));
        base.subtract(new Area(new Rectangle(x + width - 3, y + height - 3, 1, 1)));
        if (2 != height - 4) {
            gfx.setPaint(JideSwingUtilities.getLinearGradientPaint(x + 2, y + 2, x + 2, y + height - 4, new float[]{0.39f, 0.4f, 1.0f}, innerBackgroundColors));
        }
        gfx.fill(base);
    }

    @Override
    public void paintStatusBarBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (c.isOpaque()) {
            Color[] bg = state == 0 ? STATUS_BAR_BG : SPECIAL_STATUS_BAR_BG;
            Graphics2D g2d = (Graphics2D)g.create();
            int y = rect.y;
            g2d.setColor(bg[0]);
            g2d.drawLine(rect.x, y, rect.x + rect.width, y);
            g2d.setColor(bg[1]);
            g2d.drawLine(rect.x, ++y, rect.x + rect.width, y);
            Rectangle r = new Rectangle(rect.x, ++y, rect.width, (rect.height - 4) / 3);
            JideSwingUtilities.fillGradient(g2d, r, bg[2], bg[3], true);
            r.y += r.height;
            r.height = rect.height - r.y - 2;
            JideSwingUtilities.fillGradient(g2d, r, bg[4], bg[5], true);
            y = r.y + r.height;
            g2d.setColor(bg[6]);
            g2d.drawLine(rect.x, y, rect.x + rect.width, y);
            g2d.setColor(bg[7]);
            g2d.drawLine(rect.x, ++y, rect.x + rect.width, y);
            g2d.dispose();
        }
    }

    @Override
    public void paintStatusBarSeparator(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(new Color(9284821));
        g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
        g.setColor(new Color(0xFFFFFF));
        g.drawLine(rect.x + 1, rect.y, rect.x + 1, rect.y + rect.height);
    }

    @Override
    public void paintMenuShadow(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (c.getClientProperty("vsnet.paintShadow") != Boolean.FALSE) {
            super.paintMenuShadow(c, g, rect, orientation, state);
            g.setColor(new Color(0xC5C5C5));
            g.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
        } else {
            g.setColor(this.getMenuItemBackground());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void paintMenuItemBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state, boolean showBorder) {
        if (c.getClientProperty(IS_MENU_PART_BUTTON) == Boolean.TRUE) {
            this.paintButtonBackground(c, g, rect, orientation, state, showBorder);
        } else {
            JideSwingUtilities.drawImageBorder(g, IconsFactory.getImageIcon(Office2007Painter.class, "icons/menu_item_bg.png"), rect, new Insets(2, 2, 2, 2), true);
        }
    }

    @Override
    public void paintPopupMenuSeparator(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        int defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
        super.paintPopupMenuSeparator(c, g, rect, orientation, state);
        g.setColor(new Color(0xC5C5C5));
        g.drawLine(rect.x + defaultShadowWidth, rect.y, rect.x + defaultShadowWidth, rect.y + rect.height);
    }

    public void paintDropDownIcon(Graphics g, int x, int y) {
        g.setColor(new Color(5668273));
        g.drawLine(x, y, x + 5, y);
        g.drawLine(x + 1, y + 1, x + 4, y + 1);
        g.drawLine(x + 2, y + 2, x + 3, y + 2);
    }

    @Override
    public void paintCommandBarBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCommandBarBackground(c, g, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCommandBarBackground(c, g, rect, orientation, state);
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        Graphics2D g2d = (Graphics2D)g.create();
        Color[] colors = new Color[]{new Color(15266300), new Color(15266300), new Color(13820404), new Color(15463421)};
        for (int i = 0; i < colors.length; ++i) {
            Color color = colors[i];
            colors[i] = ColorUtils.getDerivedColor(color, 0.47f);
        }
        if (1 != height - 2) {
            g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x + 1, y + 1, x + 1, y + height - 2, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, colors));
        }
        g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(10);
        g2d.setComposite(SystemInfo.isJdk6Above() ? alphaComposite.derive(0.1f) : AlphaComposite.getInstance(alphaComposite.getRule(), 0.1f));
        this.paintButtonBorder(c, g2d, rect, state);
        g2d.dispose();
    }

    @Override
    public void paintFloatingCommandBarBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintFloatingCommandBarBackground(c, g, rect, orientation, state);
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        Graphics2D g2d = (Graphics2D)g.create();
        Color[] colors = new Color[]{new Color(15266300), new Color(15266300), new Color(13820404), new Color(15463421)};
        for (int i = 0; i < colors.length; ++i) {
            Color color = colors[i];
            colors[i] = ColorUtils.getDerivedColor(color, 0.48f);
        }
        if (height != 0) {
            g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x, y, x, y + height, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, colors));
        }
        g2d.fillRect(x, y, width, height);
        g2d.dispose();
    }

    @Override
    public void paintDockableFrameTitlePane(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintDockableFrameTitlePane(c, g, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintDockableFrameTitlePane(c, g, rect, orientation, state);
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        if (c.getBorder() != null) {
            Insets insets = c.getBorder().getBorderInsets(c);
            x += insets.left;
            y += insets.top;
            w -= insets.right + insets.left;
            h -= insets.top + insets.bottom;
        }
        boolean active = state == 3;
        Color[] colors = active ? ACTIVE_DOCKABLE_FRAME_TITLE_BAR_BG : DOCKABLE_FRAME_TITLE_BAR_BG;
        Graphics2D g2d = (Graphics2D)g.create();
        Color old = g2d.getColor();
        g2d.setColor(Color.WHITE);
        g2d.drawLine(x, y, x + w, y);
        g2d.drawLine(x, y, x, y + h);
        g2d.setColor(old);
        if (h != 0) {
            g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x + 1, y + 1, x + 1, y + h - 1, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors));
        }
        g2d.fillRect(x + 1, y + 1, w - 1, h - 1);
        g2d.dispose();
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackground(c, g, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackground(c, g, rect, orientation, state);
            return;
        }
        this.paintCollapsiblePaneTitlePane(c, g, rect, COLLAPSIBLE_PANE_TITLE_BAR_BG, orientation, state);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundEmphasized(c, g, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackgroundEmphasized(c, g, rect, orientation, state);
            return;
        }
        this.paintCollapsiblePaneTitlePane(c, g, rect, EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_BG, orientation, state);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(c, g, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(c, g, rect, orientation, state);
            return;
        }
        this.paintCollapsiblePaneTitlePaneSeparator(c, g, rect, EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG, state);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparator(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundSeparator(c, g, rect, orientation, state);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackgroundSeparator(c, g, rect, orientation, state);
            return;
        }
        this.paintCollapsiblePaneTitlePaneSeparator(c, g, rect, COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG, state);
    }

    private void paintCollapsiblePaneTitlePane(JComponent c, Graphics g, Rectangle rect, Color[] colors, int orientation, int state) {
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        if (c.getBorder() != null) {
            Insets insets = c.getBorder().getBorderInsets(c);
            x += insets.left;
            y += insets.top;
            w -= insets.right + insets.left;
            h -= insets.top + insets.bottom;
        }
        if (h != 0) {
            Graphics2D g2d = (Graphics2D)g.create();
            Paint paint = null;
            switch (orientation) {
                case 3: {
                    if (state == 2) {
                        Color[] newColors = new Color[colors.length];
                        for (int i = 0; i < colors.length; ++i) {
                            Color color = colors[i];
                            newColors[i] = ColorUtils.getDerivedColor(color, 0.6f);
                        }
                        paint = JideSwingUtilities.getLinearGradientPaint(x, y, x + w, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, newColors);
                        break;
                    }
                    paint = JideSwingUtilities.getLinearGradientPaint(x, y, x + w, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors);
                    break;
                }
                case 7: {
                    if (state == 2) {
                        Color[] newColors = new Color[colors.length];
                        for (int i = 0; i < colors.length; ++i) {
                            Color color = colors[i];
                            newColors[i] = ColorUtils.getDerivedColor(color, 0.6f);
                        }
                        paint = JideSwingUtilities.getLinearGradientPaint(x + w, y, x, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, newColors);
                        break;
                    }
                    paint = JideSwingUtilities.getLinearGradientPaint(x + w, y, x, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors);
                    break;
                }
                case 1: {
                    if (state == 2) {
                        Color[] newColors = new Color[colors.length];
                        for (int i = 0; i < colors.length; ++i) {
                            Color color = colors[i];
                            newColors[i] = ColorUtils.getDerivedColor(color, 0.6f);
                        }
                        paint = JideSwingUtilities.getLinearGradientPaint(x, y + h, x, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, newColors);
                        break;
                    }
                    paint = JideSwingUtilities.getLinearGradientPaint(x, y + h, x, y, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors);
                    break;
                }
                case 5: {
                    if (state == 2) {
                        Color[] newColors = new Color[colors.length];
                        for (int i = 0; i < colors.length; ++i) {
                            Color color = colors[i];
                            newColors[i] = ColorUtils.getDerivedColor(color, 0.6f);
                        }
                        paint = JideSwingUtilities.getLinearGradientPaint(x, y, x, y + h, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, newColors);
                        break;
                    }
                    paint = JideSwingUtilities.getLinearGradientPaint(x, y, x, y + h, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colors);
                }
            }
            g2d.setPaint(paint);
            g2d.fillRect(x, y, w, h);
            g2d.dispose();
        }
    }

    private void paintCollapsiblePaneTitlePaneSeparator(JComponent c, Graphics g, Rectangle rect, Color[] colors, int state) {
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        if (c.getBorder() != null) {
            Insets insets = c.getBorder().getBorderInsets(c);
            x += insets.left;
            y += insets.top;
            w -= insets.right + insets.left;
            h -= insets.top + insets.bottom;
        }
        if (h != 0) {
            Graphics2D g2d = (Graphics2D)g.create();
            if (state == 2) {
                Color[] newColors = new Color[colors.length];
                for (int i = 0; i < colors.length; ++i) {
                    Color color = colors[i];
                    newColors[i] = ColorUtils.getDerivedColor(color, 0.6f);
                }
                g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x, y, x + w, y, new float[]{0.0f, 0.5f, 1.0f}, newColors));
            } else {
                g2d.setPaint(JideSwingUtilities.getLinearGradientPaint(x, y, x + w, y, new float[]{0.0f, 0.5f, 1.0f}, colors));
            }
            g2d.fillRect(x, y, w, h);
            g2d.dispose();
        }
    }

    @Override
    public void paintCollapsiblePanesBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!c.isOpaque()) {
            return;
        }
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue()) {
            super.paintCollapsiblePanesBackground(c, g, rect, orientation, state);
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (!(c.getBackground() instanceof UIResource)) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), c.getBackground(), ColorUtils.getDerivedColor(c.getBackground(), 0.6f), orientation == 0);
        } else {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), UIDefaultsLookup.getColor("CollapsiblePanes.backgroundLt"), UIDefaultsLookup.getColor("CollapsiblePanes.backgroundDk"), orientation == 0);
        }
    }

    @Override
    public void paintSidePaneItemBackground(JComponent c, Graphics g, Rectangle rect, Color[] colors, int orientation, int state) {
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue() || colors != null && colors.length >= 1 && colors[0] != null && !(colors[0] instanceof UIResource)) {
            super.paintSidePaneItemBackground(c, g, rect, colors, orientation, state);
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        switch (orientation) {
            case 3: 
            case 7: {
                g2d.rotate(-Math.toRadians(90.0), rect.x, rect.y);
                g2d.translate(-rect.height, rect.y);
                this.paintButtonBackground(c, g2d, new Rectangle(0, 0, rect.height, rect.width), 0, state, false);
                break;
            }
            case 1: 
            case 5: {
                this.paintButtonBackground(c, g2d, rect, 0, state, false);
            }
        }
        g2d.dispose();
    }

    @Override
    public void paintHeaderBoxBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        boolean paintBorder = !(c instanceof AbstractButton) || ((AbstractButton)c).isBorderPainted();
        this.paintButtonBackground(c, g, rect, orientation, state, paintBorder);
        if (!paintBorder) {
            Color old = g.getColor();
            g.setColor(UIDefaultsLookup.getColor("Table.gridColor"));
            g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
            g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
            g.setColor(old);
        }
    }

    @Override
    public void paintGripper(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (rect.width > 30) {
            orientation = 1;
        } else if (rect.height > 30) {
            orientation = 0;
        }
        int h = orientation == 0 ? rect.height : rect.width;
        int count = Math.min(9, (h - 6) / 4);
        int y = rect.y;
        int x = rect.x;
        if (orientation == 0) {
            y += rect.height / 2 - count * 2;
            x += rect.width / 2 - 1;
        } else {
            x += rect.width / 2 - count * 2;
            y += rect.height / 2 - 1;
        }
        for (int i = 0; i < count; ++i) {
            g.setColor(this.getGripperForegroundLt());
            g.fillRect(x + 1, y + 1, 2, 2);
            g.setColor(this.getGripperForeground());
            g.fillRect(x, y, 2, 2);
            g.setColor(ColorUtils.getDerivedColor(this.getGripperForeground(), 0.55f));
            g.fillRect(x + 1, y + 1, 1, 1);
            if (orientation == 0) {
                y += 4;
                continue;
            }
            x += 4;
        }
    }

    @Override
    public Color getGripperForegroundLt() {
        return UIDefaultsLookup.getColor("Gripper.light");
    }

    @Override
    public Color getSelectionSelectedDk() {
        return new ColorUIResource(16305011);
    }

    @Override
    public Color getSelectionSelectedLt() {
        return new ColorUIResource(16710613);
    }

    @Override
    public Color getBackgroundDk() {
        return UIDefaultsLookup.getColor("JideTabbedPane.background");
    }

    @Override
    public Color getBackgroundLt() {
        return UIDefaultsLookup.getColor("JideTabbedPane.background");
    }

    @Override
    public void fillBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state, Color color) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (orientation == 0) {
            int topHeight = rect.height / 3;
            JideSwingUtilities.fillGradient((Graphics2D)g, new Rectangle(rect.x, rect.y, rect.width, topHeight), ColorUtils.getDerivedColor(color, 0.74f), ColorUtils.getDerivedColor(color, 0.64f), true);
            JideSwingUtilities.fillGradient((Graphics2D)g, new Rectangle(rect.x, rect.y + topHeight, rect.width, rect.height - topHeight), color, ColorUtils.getDerivedColor(color, 0.64f), true);
        } else {
            int leftWidth = rect.width / 3;
            JideSwingUtilities.fillGradient((Graphics2D)g, new Rectangle(rect.x, rect.y, leftWidth, rect.height), ColorUtils.getDerivedColor(color, 0.74f), ColorUtils.getDerivedColor(color, 0.64f), false);
            JideSwingUtilities.fillGradient((Graphics2D)g, new Rectangle(rect.x + leftWidth, rect.y, rect.width - leftWidth, rect.height), color, ColorUtils.getDerivedColor(color, 0.64f), false);
        }
        g2d.dispose();
    }

    static {
        STATUS_BAR_BG = new Color[]{new Color(5668272), new Color(0xFFFFFF), new Color(14149369), new Color(13098232), new Color(11784437), new Color(14149111), new Color(13492471), new Color(12244215)};
        SPECIAL_STATUS_BAR_BG = new Color[]{new Color(5668272), new Color(12967160), new Color(12769783), new Color(11127543), new Color(9484010), new Color(7772357), new Color(7640514), new Color(9809358)};
        DOCKABLE_FRAME_TITLE_BAR_BG = new Color[]{new Color(15070461), new Color(14217212), new Color(12510973), new Color(10934772)};
        ACTIVE_DOCKABLE_FRAME_TITLE_BAR_BG = new Color[]{new Color(16769959), new Color(16764785), new Color(16761679), new Color(16762964)};
        COLLAPSIBLE_PANE_TITLE_BAR_BG = new Color[]{new Color(14149369), new Color(13098232), new Color(11784437), new Color(14149111)};
        EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_BG = new Color[]{new Color(15200510), new Color(12178423), new Color(10863853), new Color(9415117)};
        COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG = new Color[]{new Color(13098232), new Color(14149369), new Color(13098232)};
        EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG = new Color[]{new Color(12178423), new Color(15200510), new Color(12178423)};
    }
}

